<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

$client = new \Google_Client();
$client->setApplicationName('My Google Sheets App');
$client->setScopes([\Google_Service_Sheets::SPREADSHEETS]);
$client->setAuthConfig(\Yii::getAlias('@app/credentials/credentials.json'));
$service = new Google_Service_Sheets($client);

$spreadsheetId = '1p_1Og2smQfy6lq-4QIAM8r7rHQnWGXvJGePkICI19jM'; // Ganti dengan Spreadsheet ID Anda
$range = 'Sheet2!A2:D'; // Data dari baris ke-2

// Tampilkan data
$response = $service->spreadsheets_values->get($spreadsheetId, $range);
$data = $response->getValues();
?>



<?php $form = ActiveForm::begin(); ?>



<?php ActiveForm::end(); ?>

<h2>Daftar Kegiatan</h2>

<table class="table table-bordered">
    <tr>
        <th>Nama Survei</th>
        <th>Target Survei</th>
        <th>Realisasi Survei</th>
        <th>Respon Rate</th>
    </tr>
    <?php foreach ($data as $row): ?>
        <tr>
            <td><?= Html::encode($row[0] ?? '') ?></td>
            <td><?= Html::encode($row[1] ?? '') ?></td>
            <td><?= Html::encode($row[2] ?? '') ?></td>
            <td><?= Html::encode($row[3] ?? '') ?></td>
        </tr>
    <?php endforeach; ?>
</table>
