<?php
use yii\helpers\Html;
use yii\helpers\Url;

/** @var Google_Service_Calendar_Event[] $events */
?>
<?php
function toLocalTime($googleDateTime, $timezone = 'Asia/Makassar') {
    $dt = new DateTime($googleDateTime);
    $dt->setTimezone(new DateTimeZone($timezone));
    return $dt->format('d-m-Y H:i');
}
?>

<h2>Daftar Event Google Calendar</h2>

<table class="table table-bordered">
    <thead>
        <tr>
            <th>Judul</th>
            <th>Waktu Mulai</th>
            <th>Waktu Selesai</th>
            <th>Aksi</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($events as $event): ?>
            <tr>
                <td><?= Html::encode($event->getSummary()) ?></td>
                <td><?= Html::encode(toLocalTime($event->start->dateTime)) ?></td>
                <td><?= Html::encode(toLocalTime($event->end->dateTime)) ?></td>
                <td>
                    <?= Html::a('Edit', ['calendar/edit-event', 'id' => $event->id], ['class' => 'btn btn-sm btn-warning']) ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
