<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\Pjax;
use yii\bootstrap4\Modal;

$this->title = 'Daftar Event Google Calendar';
$this->params['breadcrumbs'][] = $this->title;

// Script untuk menangani klik tombol Edit
$this->registerJs("
    $(document).on('click', '.edit-event-btn', function(e) {
        e.preventDefault();
        $('#editModal').modal('show')
            .find('#modalContent')
            .load($(this).attr('href'));
    });
");
?>

<?php
function toLocalTime($googleDateTime, $timezone = 'Asia/Makassar') {
    $dt = new DateTime($googleDateTime);
    $dt->setTimezone(new DateTimeZone($timezone));
    return $dt->format('d-m-Y H:i');
}
?>

<div class="calendar-index">
    <h2><?= Html::encode($this->title) ?></h2>

    <p>
        <?= Html::a('Tambah Event', ['create-event'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(['id' => 'event-list']); ?>
    <table class="table table-bordered table-striped">
        <thead class="thead-dark">
            <tr>
                <th>Judul</th>
                <th>Mulai</th>
                <th>Selesai</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($events as $event): ?>
            <tr>
                <td><?= Html::encode($event->getSummary()) ?></td>
                <td><?= Html::encode(toLocalTime($event->start->dateTime)) ?></td>
                <td><?= Html::encode(toLocalTime($event->end->dateTime)) ?></td>
                <td>
                    <?= Html::a('Edit', ['calendar/update', 'id' => $event->getId()], [
                        'class' => 'btn btn-primary btn-sm edit-event-btn',
                        'title' => 'Edit Event'
                    ]) ?>
                    <?= Html::a('Hapus', ['calendar/delete', 'id' => $event->getId()], [
                        'class' => 'btn btn-danger btn-sm',
                        'title' => 'Hapus Event',
                        'data-confirm' => 'Yakin ingin menghapus event ini?',
                        'data-method' => 'post'
                    ]) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <?php Pjax::end(); ?>
</div>

<?php
Modal::begin([
    'title' => '<h5>Edit Event</h5>',
    'id' => 'editModal',
    'size' => 'modal-lg', // gunakan string, bukan konstanta
]);

echo '<div id="modalContent"></div>';

Modal::end();
?>
