<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use app\components\GoogleSheetService;
use Google_Client;
use Google_Service_Sheets;

class SpreadsheetController extends Controller
{
    public function actionIndex()
    {
        $sheetService = new GoogleSheetService();

        if (Yii::$app->request->isPost) {
            $nama = Yii::$app->request->post('nama');
            $email = Yii::$app->request->post('email');
            $pesan = Yii::$app->request->post('pesan');

            $sheetService->appendRow([$nama, $email, $pesan]);

            return $this->redirect(['index']);
        }

        $data = $sheetService->getAllData();
        return $this->render('index', ['data' => $data]);
    }

    public function actionSheet2()
    {
        $sheetService = new GoogleSheetService();

        $data = $sheetService->getAllData();
        return $this->render('sheet2', ['data' => $data]);
    }
   
    public function actionTambahEvent()
{
    $calendar = new \app\components\GoogleCalendarService();

    $start = '2025-05-26T10:00:00+08:00';
    $end   = '2025-05-26T11:00:00+08:00';

    $reminders = [
        ['method' => 'email', 'minutes' => 30],
        ['method' => 'popup', 'minutes' => 10],
    ];

    try {
        $link = $calendar->createEvent(
            'Rapat Koordinasi',
            'Rapat bersama tim statistik',
            $start,
            $end,
            $reminders
        );
        return $this->renderContent("Event berhasil dibuat: <a href='$link' target='_blank'>$link</a>");
    } catch (\Exception $e) {
        return $this->renderContent("Gagal membuat event: " . $e->getMessage());
    }
}

}

    

